﻿<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <script runat="server">
        public class ParametryContext : ContextBase {
            
            public ParametryContext(Context cx)
                : base(cx) {
                magazyn = (Magazyn)cx[typeof(Magazyn)];
            }

            Date dataInw = Date.Now;

            [Priority(10)]
            [Caption("Data inwentaryzacji")]
            public Date DataInw {
                get { return dataInw; }
                set { dataInw = value; OnChanged(EventArgs.Empty); }
            }

            Magazyn magazyn = null;

            [Priority(20)]
            [Caption("Magazyn")]
            public Magazyn Magazyn {
                get { return magazyn; }
                set { magazyn = value; OnChanged(EventArgs.Empty); }
            }
            
            bool stanyZerowe = false;
            
            [Priority(30)]
            [Caption("Stany zerowe")]
            public bool StanyZerowe {
                get { return stanyZerowe; }
                set { stanyZerowe = value; OnChanged(EventArgs.Empty); }
            }
        }

        ParametryContext parametry;

        [Context]
        public ParametryContext Parametry {
            get { return parametry; }
            set { parametry = value; }
        }
        
        public class Stany {
            Quantity ilośćNaDzień = Quantity.Zero;
            decimal wartośćMagazynu = 0M;
            public Stany(Towar towar, ParametryContext parametry) {
                StanMagazynuWorker smw = new StanMagazynuWorker();
                smw.Towar = towar;
                smw.Magazyn = parametry.Magazyn;
                smw.Data = parametry.DataInw;
                
                ilośćNaDzień = smw.StanMagazynu;
                wartośćMagazynu = smw.WartośćMagazynu;
            }
            public Quantity IlośćNaDzień {
                get { return ilośćNaDzień; }
            }
            public decimal WartośćMagazynu {
                get { return wartośćMagazynu; }
            }
        }
        
        public class Total : IComparable {
            readonly Towar towar;
            readonly Quantity ilośćNaDzień;
            readonly decimal wartośćMagazynu;
            public Total(Towar towar, Quantity ilośćNaDzień, decimal wartośćMagazynu) {
                this.towar = towar;
                this.ilośćNaDzień = ilośćNaDzień;
                this.wartośćMagazynu = wartośćMagazynu;
            }
            public Towar Towar {
                get { return towar; }
            }
            public Quantity IlośćNaDzień {
                get { return ilośćNaDzień; }
            }
            public decimal WartośćMagazynu {
                get { return wartośćMagazynu; }
            }
            public int CompareTo(object obj) {
                Total t = (Total)obj;
                return Towar.Kod.CompareTo(t.Towar.Kod);
            }
        }

        SubTable ZnajdzINWiPochodne(HandelModule hm)
        {
          var posredni = hm.DokHandlowe.WgMagazyn[Parametry.Magazyn, Parametry.DataInw];

          return posredni[new RowCondition.Exists("Definicja", "DefRelacjiHandlowej", "DefinicjaNadrzednego", new FieldCondition.Equal("Typ", TypRelacjiHandlowej.Inwentaryzacja))];
        }

        bool IstniejeNaDokInw(Towar towar) {
            HandelModule hm = HandelModule.GetInstance(dc.Session);
            var dokumentyInw = ZnajdzINWiPochodne(hm);
            if (dokumentyInw.Count == 0)
                throw new Exception("Brak dokumentów inwentaryzacji na magazynie: '" + Parametry.Magazyn + "' z datą: '" + Parametry.DataInw + "'");
            foreach (DokumentHandlowy dokument in dokumentyInw)
                foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje)
                    if (pozycja.Towar == towar)
                        return true;
            return false;
        }
        
        protected void dc_ContextLoad(object sender, EventArgs e) {
            ReportHeader.Title += string.Format("|Magazyn: {0}|Data: {1}", Parametry.Magazyn, Parametry.DataInw);

            TowaryModule tm = TowaryModule.GetInstance(dc.Session);
           Soneta.Business.View towaryView = tm.Towary.WgNazwy.CreateView();
            if (Parametry.StanyZerowe)
                towaryView.Condition &= tm.Towary.UtwórzCondition(FiltrStanuTowaru.Dowolny, Parametry.Magazyn, tm.Magazyny.OkresyMag.Aktualny);
            else
                towaryView.Condition &= tm.Towary.UtwórzCondition(FiltrStanuTowaru.NieZerowy, Parametry.Magazyn, tm.Magazyny.OkresyMag.Aktualny);
            
            Hashtable result = new Hashtable();
            foreach (Towar towar in towaryView) {
                if (!IstniejeNaDokInw(towar)) {
                    Stany stany = new Stany(towar, Parametry);
                    Total t = new Total(towar, stany.IlośćNaDzień, stany.WartośćMagazynu);
                    result.Add(t.Towar, t);
                }
            }
            ArrayList list = new ArrayList(result.Values);
            list.Sort();
            Grid.DataSource = list;
        }

    </script>
    <title>Towary niezinwentaryzowane</title>
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server" action="#">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" runat="server" Title="Towary niezinwentaryzowane"></eb:ReportHeader>
        <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Towary.Towar,Soneta.Handel">
            <Columns>
                <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp.">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Left" DataMember="Towar" Caption="Towar">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" DataMember="IlośćNaDzień" Caption="Ilość na dzień" Width="20">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" DataMember="WartośćMagazynu" Caption="Wartość magazynu" Width="20" Total="Sum">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="false">
        </eb:ReportFooter>
    </form>
</body>
</html>

